
///////////////////////////////////////////////////////////////////////////////
//
//   ROCKWELL SEMICONDUCTOR SYSTEMS - COMMERCIAL GPS BUSINESS
//
///////////////////////////////////////////////////////////////////////////////
//
//
//   ALM_SEND.C - Almanac Send
// 
//
//   DESCRIPTION
//
//   Functions for sending almanacs to and retrieving almanacs from the
//   receiver.
//
//
//   REVISION HISTORY
//
//   $Log:   V:\Projects\Labmon\Source\Archives\ALM_SEND.C_V  $
//   
//      Rev 1.15   09 Nov 1998 10:44:08   phungh
//   labmon51: Fix file logging and missing
//   logged data bugs.  Changes made to the 
//   "Pause" variable ( 1 -> 0 ) to allow main
//   loop continue.  Move the "write to file"
//   code portion out of the interrupt handler
//   so that data is not missed because of time
//   spent too long in the interrupt handler
//   
//      Rev 1.3   Jul 09 1997 09:42:52   COLEJ
//   Multiple Changes...
//   
//      Rev 1.2   Feb 12 1997 16:04:54   COLEJ
//    
//   
//      Rev 1.1   Aug 13 1996 13:00:42   COLEJ
//    
//   
//      Rev 1.0   13 May 1996 14:52:22   GPSADMIN
//   Initial release to version control.
//
//
////////////////////////////////////////////////////////////////////////////////

#include <stdio.h>
#include <stdlib.h>
#include <conio.h>
#include <dos.h>
#include <graph.h>
#include <string.h>
#include <share.h>

#include "LABMON.H"
#include "INITFUNC.H"
#include "MESS_IO.H"
#include "MONMISC.H"

extern char          buff[80];
extern unsigned char msgbuff[MAX_MSG_BUFFER];           
extern unsigned char tx_buff[MAX_TX_BUFFER];
extern unsigned char filebuff[4000];
extern short         cmdline; 
extern short         MainTextColor;  
extern short         MainDataColor;  
extern unsigned long cnt205, Cnt1240;

extern tDATATYPE DataType;

static unsigned short        AlmCount = 0;
static FILE                 *Alm_FilePtr = NULL;

short get_almanac_file(void)
{
   short   option; 
   char  FileName[35];
   short   valid;                                            

   clear_message_line();  
   _outtext("SELECT FILE -> ");
   _settextcolor(MainTextColor);
   _outtext( "A" );
   _settextcolor(MainDataColor);
   _outtext( "LMANAC.GPS  " );
   _settextcolor(MainTextColor);

   _outtext( "O" );
   _settextcolor(MainDataColor);
   _outtext( "THER" );

   option = getch();  
   clear_message_line();
   strcpy(FileName, "ALMANAC.GPS");
   
   if(option != 'A' && option != 'a'){
      clear_message_line();
      ask_str("ALMANAC FILE NAME -> ", FileName, &valid);
      //_outtext("ALMANAC FILE NAME -> ");
      //getns(FileName, 35);
      clear_message_line(); 
      if(!valid) return(1);     
   }
   clear_message_line(); 
      
   if((Alm_FilePtr = _fsopen(FileName, "rb", SH_DENYWR)) == NULL){
      clear_message_line();
      _outtext("COULDN'T OPEN ALMANAC FILE!\7");
      return(1);
   }
   else{
      return(0);
   }
}
 
short send_almanac(void)
{
   short i; 
   
   if(Alm_FilePtr == NULL){
      return(1);
   }

   if(DataType == NC_BINARY){
     // read another almanac record
     for(i=0;i<86;i++){
        tx_buff[i] = (unsigned char)fgetc(Alm_FilePtr);
        //if(tx_buff[i] == (unsigned char)EOF){
           // end of file
        //   return (1);  
        //}
     }
 
     if(*(short*)(tx_buff+2) == 205){
        sprintf(buff, "ALMANAC FOR SV #%2d  SENT %2d OF %2d",
           *(short*)(tx_buff+16), *(short*)(tx_buff+14), *(short*)(tx_buff+12));
        clear_message_line();
        _outtext(buff);
        cnt205++;
        send_msg(tx_buff);
     }
     return(0);
   } //end if NC_BINARY
   
   if(DataType == Z_BINARY){
     // read another almanac record
     for(i=0;i<844;i++){
       tx_buff[i] = (unsigned char)fgetc(Alm_FilePtr);
       //if(tx_buff[i] == (unsigned char)EOF){
         // end of file
       //  cputs("\a");
       //  return (1);  
       //}
     }
 
     if(*(short*)(tx_buff+2) == 1240){
        cputs("\a");
        sprintf(buff, "ALMANAC SENT");
        clear_message_line();
        _outtext(buff);
        Cnt1240++;
        send_msg(tx_buff);
     }
     return(0);
   } //end if Z_BINARY 
     
}


short store_alm(short file_len)
{
   short i;

   if((Alm_FilePtr = _fsopen("ALMANAC.GPS", "wb", SH_DENYWR)) == NULL) {
      clear_message_line();
      _outtext("COULDN'T OPEN ALMANAC DATA FILE!");
      return(1);
   }
   else{
      clear_message_line();
      _outtext("ALMANAC DATA FILE OPENED");

      for(i=0;i<file_len; i++){
         fputc(filebuff[i], Alm_FilePtr);
      }
      fputc(file_len, Alm_FilePtr);
      fclose(Alm_FilePtr);
      clear_message_line();
      _outtext("ALMANAC DATA FILE CLOSED     "); 
      return(0);
   }
}
